#script for producing figs for manuscript
library(ggplot2)
library(gridExtra)
source('rps_functions.R')

set.seed(99)
rps_data<-rps_tournament_changepoint(n_games=100,choice_set1=choices,choice_set2=setdiff(choices,"Rock"),choice_set1_change=setdiff(choices,"Paper"),changepoint=50)
rps_fit_map(rps_data$simulated_data,50,100)
rps_dyn_fit<-rps_fit_map_dyn(rps_data$simulated_data,50,100)
rps_gs_out<-rps_gs(rps_data$simulated_data,d1=100,m=50,v=1000)



k_prior_approx<-function(x,m,v) {
    # continuous approximation to prior (for graphical purposes)
    
    size<-m^2/(v-m)
    y1=    dnbinom(floor(x),size=size,mu=m)
    y2= dnbinom(floor(x)-1,size=size,mu=m)
    z=x-floor(x)
    (1-z)*y1+z*y2
}

data_df=data.frame(index=1:length(rps_gs_out$k_out),k_out=rps_gs_out$k_out)

p1<-ggplot(data=data_df,aes(x=index,y=k_out))+geom_line()+ggtitle('Gibbs sample Output for Changepoint')+theme(plot.title = element_text(hjust = 0.5))+xlab("iteration") + ylab("k")


p2<-ggplot(data=data_df,aes(x=k_out))+geom_histogram(aes(y=..density..),binwidth=20,boundary=0,color="black", fill="gray")+stat_density(adjust=3,color="green",geom="line")+
    stat_function(fun=k_prior_approx,args=list(m=50,v=1000),color="red",data=data.frame(k_out=0:200))+
    ggtitle("Prior-Posterior Comparison of Changepoint Distribution")+theme(plot.title = element_text(hjust = 0.5))+xlab("k") 

grid.arrange(p1,p2,ncol=2)

gibbs_plot(rps_gs_out)